import serial
import time
import struct
import EasyVolts_SWI2C

def initADXL345(serialPort):
    writeBuff = bytearray([0x2d,0x08]) #write 0x08 in 0x2D register to enable measurements. Default mode (10bit, +-2g) is used
    EasyVolts_SWI2C.DoI2cTransaction(serialPort, 0x53,len(writeBuff), writeBuff, 0, 0, 0)
    
def readADXL345_XYZ(serialPort):
    #define needed data register addr in the request buffer
    writeBuff = bytearray([0x32])
    readBuff = bytearray(6) #we will read all 3 signed int values, one for each axis
    EasyVolts_SWI2C.DoI2cTransaction(serialPort,0x53,len(writeBuff), writeBuff, len(readBuff), readBuff, 1) #do StartRepeat because it's reading
    axisXYZ_out = struct.unpack('<hhh', readBuff)
    return axisXYZ_out

#main program starts here
print("Open control serial port.")
serialPort = serial.Serial('COM24')#set your port name here
print('Set voltage:2800mV. Set current protection limit: 50mA.')
serialPort.write(b'u2800\r') #set voltage value
serialPort.write(b'i50\r') #set current limit value
time.sleep(0.5)

print("Init I2C bus")
EasyVolts_SWI2C.init(serialPort)
print("Scan I2C devices")
detectDevicesArray = EasyVolts_SWI2C.ScanDevices(serialPort)
print("Detected devices:")
for device in detectDevicesArray:
    print('\t' + hex(device))

#init ADXL345 sensor
print("Init ADXL345(0x53) accelerometer")
initADXL345(serialPort)

print("Measure acceleration on all 3 axis")
try:
    while(1):
        xyz = readADXL345_XYZ(serialPort)
        print('x=' + '{:6}'.format(xyz[0]) + '; y=' + '{:6}'.format(xyz[1]) + '; z=' + '{:6}'.format(xyz[2]) + '\r', end='')

except KeyboardInterrupt:
    pass

#before exit set output power to 0 and TxRx pins to Z state
serialPort.write(b'u0\r')
serialPort.write(b'zT\r')
serialPort.write(b'zR\r')
serialPort.close()    
print("Exit!")
