import serial
import time


def WaitHalfClock():
    #time.sleep(0.00001)
    return
    
def WriteSCL(serialPort, bitValue):
    #set/reset Tx pin as open drain
    if(bitValue):
        serialPort.write(b'zTh\r')
    else:
        serialPort.write(b'lT\r')   
    
def WriteSDA(serialPort, bitValue):
    #set/reset Rx pin as open drain
    if(bitValue):
        serialPort.write(b'zRh\r')
    else:
        serialPort.write(b'lR\r')
        
def ReadSCL(serialPort):
    serialPort.flushInput()
    serialPort.write(b'rT\r') #request Tx pin READ
    while(1):
        #read response with Tx pin input state (button state)
        line = str(serialPort.readline(), 'utf-8')
        if("T0\r\n" == line):
            return 0
        if("T1\r\n" == line):
            return 1

def ReadSDA(serialPort):
    serialPort.flushInput()
    serialPort.write(b'rR\r') #request Rx pin READ
    while(1):
        #read response with Rx pin input state (button state)
        line = str(serialPort.readline(), 'utf-8')
        #print(line)
        if("R0\r\n" == line):
            return 0
        if("R1\r\n" == line):
            return 1

def SendStart(serialPort):
    #Sending the START
    WriteSDA(serialPort,0)
    WaitHalfClock()
    WriteSCL(serialPort,0)
    WaitHalfClock()

def SendStop(serialPort):
    WriteSCL(serialPort,0)
    WaitHalfClock()
    WriteSDA(serialPort,0)
    WaitHalfClock()
    WriteSCL(serialPort,1)
    WaitHalfClock()
    WriteSDA(serialPort,1)
    WaitHalfClock()
    
#software I2C init
def init(serialPort):
    #prepare EasyVolts for I2C communication
    #print('Set Modbus mode.')
    serialPort.write(b'M\r') #set modbus mode to make UART RxTx pins free to use them as GPIO
    #print('Set Tx pin to Z+pullUp mode.')
    serialPort.write(b'zTh\r') #set TX pin in Z+pullUp mode. It will be used as SCL
    #print('Set Rx pin to Z+pullUp mode.')
    serialPort.write(b'zRh\r') #set RX pin in Z+pullUp mode. It will be used as SDA
    #Reset I2C bus
    WriteSCL(serialPort,1)
    WriteSDA(serialPort,1)
    #send 9 clocks to reset I2C bus state
    j=0
    while(j<9):
        WaitHalfClock()
        WriteSCL(serialPort,0)
        WaitHalfClock()
        WriteSCL(serialPort,1)
        j += 1
    #Sending out the stop bit
    SendStop(serialPort)

def writeData(serialPort, addr, outputArray, size, sendStopFlag):
    #Sending the START
    SendStart(serialPort)
    
    #Next doing the control byte
    temp = (addr << 1)
    bits = 8
    
    #Loop until all bits of the address byte are sent out */
    while(1):
        #Deciding if we want to send a high or low out of the line */
        if (temp & 0x80):                 
            WriteSDA(serialPort,1)
        else:
            WriteSDA(serialPort,0)            
        #Now that we set the SDA line, we have to send out a clock pulse */
        WriteSCL(serialPort,1)
        WaitHalfClock()
        #Incrementing to the next bit and waiting for the next clock cycle */
        temp = (temp << 1)
        bits = (bits - 1)
        WriteSCL(serialPort,0)
        WaitHalfClock()
        if(bits == 0):
            break
    #Detecting if we have a NAK on the bus. If the slave device NAKed the control byte, it probably isn't there on the bus so we should send
    # an I2C stop and return 0
    WriteSDA(serialPort,1)
    WriteSCL(serialPort,1)
    WaitHalfClock()
    if(ReadSDA(serialPort)):
        SendStop(serialPort)
        return 0
    #Sending out another clock cycle
    WriteSCL(serialPort,0)
    WaitHalfClock()
    #Next, let us send out all bytes in the user buffer
    ii=0
    while(ii<size):
        temp = outputArray[ii]
        bits = 8
        #Loop until all bits of the current byte are sent out
        while(1):
            #Deciding if we want to send a high or low out of the line
            if (temp & 0x80):               
                WriteSDA(serialPort,1)
            else:
                WriteSDA(serialPort,0)  
            #Now that we set the SDA line, we send out a clock pulse
            WriteSCL(serialPort,1)
            WaitHalfClock()
            #Incrementing to the next bit and waiting for next clock cycle */
            temp = (temp << 1)
            bits = (bits - 1)
            WriteSCL(serialPort,0)
            WaitHalfClock()
            if (bits == 0):
                break
        #Detecting the NAK. We should break out of the send loop */
        WriteSDA(serialPort,1)
        WriteSCL(serialPort,1)
        WaitHalfClock()
        if(ReadSDA(serialPort)):
            SendStop(serialPort)
            return 0;
        
        #Sending out another clock cycle */
        WriteSCL(serialPort,0)
        WaitHalfClock()
        ii += 1

    #If the user did not request to skip, we send out the stop bit
    if (sendStopFlag):
        SendStop(serialPort)
    else:
        WriteSCL(serialPort,1);
        WaitHalfClock();
        WriteSDA(serialPort,1);
    WaitHalfClock();
    return 1

def readData(serialPort, addr, inputArray, size):
   #Sending the START
    SendStart(serialPort)
    
    #Next doing the control byte
    temp = (addr << 1) + 1
    bits = 8
    
    #Loop until all bits of the address byte are sent out */
    while(1):
        #Deciding if we want to send a high or low out of the line */
        if (temp & 0x80):                 
            WriteSDA(serialPort,1)
        else:
            WriteSDA(serialPort,0)            
        #Now that we set the SDA line, we have to send out a clock pulse */
        WriteSCL(serialPort,1)
        WaitHalfClock()
        #Incrementing to the next bit and waiting for the next clock cycle */
        temp = (temp << 1)
        bits = (bits - 1)
        WriteSCL(serialPort,0)
        WaitHalfClock()
        if(bits == 0):
            break
    #Detecting if we have a NAK on the bus. If the slave device NAKed the control byte, it probably isn't there on the bus so we should send
    # an I2C stop and return 0
    WriteSDA(serialPort,1)
    WriteSCL(serialPort,1)
    WaitHalfClock()
    if(ReadSDA(serialPort)):
        SendStop(serialPort)
        return 0
    
    #Next, we want to read out all of the data requested
    ii=0;
    while(ii<size):
        #Setup the read variables
        temp = 0
        bits = 0x08

        #Sending out another clock cycle
        WaitHalfClock();
        WriteSCL(serialPort,0);
        WaitHalfClock();
        WriteSDA(serialPort,1);

        #Loop to read until all bits have been read
        while(1):
            #Priming our temporary variable and sending a clock pulse
            temp = (temp << 1)
            WriteSCL(serialPort,1)
            WaitHalfClock()
            #If the data line is high, recording that
            if (ReadSDA(serialPort)):
              temp += 1
            
            #Send out another clock cycle and decrement our counter
            bits = (bits - 1);
            WriteSCL(serialPort,0);
            WaitHalfClock();
            if (bits == 0):
                break;

        #Storing the data off
        inputArray[ii] = temp
        ii += 1
        #Now the master needs to send out the ACK or NACK if it was last byte to read*/
        if(ii<size):
            WriteSDA(serialPort,0)
        else:
            WriteSDA(serialPort,1)
        WriteSCL(serialPort,1);
        WaitHalfClock();

    #Sending out the stop bit */
    SendStop(serialPort)

    #If all bytes were read, return 1- otherwise 0.
    if(ii == size):
        return 1
    else:
        return 0

#writeBuffer and readBuffer are bytesarray
def DoI2cTransaction(serialPort, address,numWriteBytes, writeBuffer, numReadBytes, readBuffer, repeatedStartFlag):
    if(numWriteBytes > 0):
        #Only skipping the stop if we have a repeated start to send
        if(repeatedStartFlag and (numReadBytes > 0)):
            if (0 == writeData(serialPort, address,writeBuffer, numWriteBytes,0)):
                return 0
        else:
            if (0 == writeData(serialPort, address, writeBuffer, numWriteBytes,1)):
                return 0

    #Next doing the read */
    if (numReadBytes > 0):
        if (0 == readData(serialPort, address, readBuffer, numReadBytes)):
            return 0
    return 1

#returns bytearray with addresses of all detected devices
def ScanDevices(serialPort):
    #print("Scan I2C devices:\r\n")
    detectReportArray = bytearray()
    outputArray = bytearray(1)
    addr = 0
    while(addr < 128):
        time.sleep(0.001)
        if(writeData(serialPort, addr, outputArray, 0, 1)):
            detectReportArray.append(addr)
        addr += 1
    return detectReportArray
